/*!\file Segment.h
 * \brief: header file for node object
 */

#ifndef _SEGMENT_H_
#define _SEGMENT_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
/*}}}*/

class Segment: public Object{

	public:
		int eid;
		double x1;
		double y1;
		double x2;
		double y2;

		/*Segment constructors, destructors {{{1*/
		Segment();
		Segment(int eid,double x1,double y1, double x2, double y2);
		~Segment();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
};

#endif  /* _SEGMENT_H_ */
