function [analyses,numanalyses,solutioncore]=SolutionConfiguration(solutiontype),
%SOLUTIONCONFIGURATION - return type of analyses, number of analyses and solution_core function
%
%   Usage:
%      [analyses, numanalyses, solutioncore]=SolutionConfiguration(solutiontype);

switch solutiontype,

	case DiagnosticSolutionEnum,
		numanalyses=6;
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticStokesAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum];
		solutioncore='diagnostic_core';

	case SteadystateSolutionEnum,
		numanalyses=8; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticStokesAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];
		solutioncore='steadystate_core';

	case ThermalSolutionEnum,
		numanalyses=2; 
		analyses=[ThermalAnalysisEnum;MeltingAnalysisEnum];
		solutioncore='thermal_core';

	case PrognosticSolutionEnum,
		numanalyses=1; 
		analyses=[PrognosticAnalysisEnum];
		solutioncore='prognostic_core';

	case BalancedthicknessSolutionEnum,
		numanalyses=1; 
		analyses=[BalancedthicknessAnalysisEnum];
		solutioncore='balancedthickness_core';

	case BalancedvelocitiesSolutionEnum,
		numanalyses=1; 
		analyses=[BalancedvelocitiesAnalysisEnum];
		solutioncore='balancedvelocities_core';

	case SurfaceSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[SurfaceSlopeAnalysisEnum];
		solutioncore='surfaceslope_core';

	case BedSlopeSolutionEnum,
		numanalyses=1; 
		analyses=[BedSlopeSolutionEnum];
		solutioncore='bedslope_core';

	case Transient2DSolutionEnum,
		numanalyses=7; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticStokesAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum];
		solutioncore='transient2d_core';

	case Transient3DSolutionEnum,
		numanalyses=9; 
		analyses=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticStokesAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum;PrognosticAnalysisEnum;ThermalAnalysisEnum;MeltingAnalysisEnum];
		solutioncore='transient3d_core';

	otherwise
		error('%s%s%s',' solution type: ',EnumAsString(solutiontype),' not supported yet!');

end
