/*!\file:  SolutionConfiguration.cpp
 * \brief: return type of analyses, number of analyses and core solution function.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"


void SolutionConfiguration(int** panalyses,int* pnumanalyses, void (**psolutioncore)(FemModel*),int solutiontype){

	/*output: */
	int  numanalyses;
	int* analyses=NULL;
	void (*solutioncore)(FemModel*)=NULL;

	switch(solutiontype){
	
		case DiagnosticSolutionEnum:
			numanalyses=6;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticStokesAnalysisEnum;
			analyses[3]=DiagnosticHutterAnalysisEnum;
			analyses[4]=SurfaceSlopeAnalysisEnum;
			analyses[5]=BedSlopeAnalysisEnum;
			solutioncore=&diagnostic_core;
			break;

		case SteadystateSolutionEnum:
			numanalyses=8;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticStokesAnalysisEnum;
			analyses[3]=DiagnosticHutterAnalysisEnum;
			analyses[4]=SurfaceSlopeAnalysisEnum;
			analyses[5]=BedSlopeAnalysisEnum;
			analyses[6]=ThermalAnalysisEnum;
			analyses[7]=MeltingAnalysisEnum;
			solutioncore=&steadystate_core;
			break;

		case ThermalSolutionEnum:
			numanalyses=2;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=ThermalAnalysisEnum;
			analyses[1]=MeltingAnalysisEnum;
			solutioncore=&thermal_core;
			break;

		case PrognosticSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=PrognosticAnalysisEnum;
			solutioncore=&prognostic_core;
			break;

		case BalancedthicknessSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=BalancedthicknessAnalysisEnum;
			solutioncore=&balancedthickness_core;
			break;

		case BalancedvelocitiesSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=BalancedvelocitiesAnalysisEnum;
			solutioncore=&balancedvelocities_core;
			break;

		case SurfaceSlopeSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=SurfaceSlopeAnalysisEnum;
			solutioncore=&surfaceslope_core;
			break;

		case BedSlopeSolutionEnum:
			numanalyses=1;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=BedSlopeAnalysisEnum;
			solutioncore=&bedslope_core;
			break;

		case Transient2DSolutionEnum:
			numanalyses=7;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticStokesAnalysisEnum;
			analyses[3]=DiagnosticHutterAnalysisEnum;
			analyses[4]=SurfaceSlopeAnalysisEnum;
			analyses[5]=BedSlopeAnalysisEnum;
			analyses[6]=PrognosticAnalysisEnum;
			solutioncore=&transient2d_core;
			break;
		
		case Transient3DSolutionEnum:
			numanalyses=9;
			analyses=(int*)xmalloc(numanalyses*sizeof(int));
			analyses[0]=DiagnosticHorizAnalysisEnum;
			analyses[1]=DiagnosticVertAnalysisEnum;
			analyses[2]=DiagnosticStokesAnalysisEnum;
			analyses[3]=DiagnosticHutterAnalysisEnum;
			analyses[4]=SurfaceSlopeAnalysisEnum;
			analyses[5]=BedSlopeAnalysisEnum;
			analyses[6]=PrognosticAnalysisEnum;
			analyses[7]=ThermalAnalysisEnum;
			analyses[8]=MeltingAnalysisEnum;
			solutioncore=&transient3d_core;
			break;

		default:
			ISSMERROR("%s%s%s"," solution type: ",EnumAsString(solutiontype)," not supported yet!");
			break;
	}
	
	/*Assign output pointers:*/
	if(pnumanalyses) *pnumanalyses=numanalyses;
	if(panalyses)*panalyses=analyses;
	else xfree((void**)&analyses);
	if(psolutioncore)*psolutioncore=solutioncore;

}
