%  set up an optimization study, like might be done in Pig.par

%%  a variety of variables

%  seems to be a Matlab bug here (on Linux, not WinXP) -- unless
%  the class has been called, "empty" method can not be found
normal_uncertain;
continuous_design;
continuous_state;
linear_inequality_constraint;
linear_equality_constraint;
response_function;
objective_function;
least_squares_term;
nonlinear_inequality_constraint;
nonlinear_equality_constraint;

md.variables=struct();
md.variables.cdv=continuous_design.empty();
md.variables.cdv(end+1)=continuous_design('thickness',1,0.9,1.1);
md.variables.cdv(end+1)=continuous_design('drag',1,0.5,1.5);
md.variables.csv=continuous_state.empty();
md.variables.csv(end+1)=continuous_state('gravity',9.8);

%%  a variety of responses

md.responses=struct();
md.responses.of =objective_function.empty();
md.responses.of (end+1)=objective_function('max_vel');

%%  an optimization study

md.qmu_method     =dakota_method('conmin_f');
md.qmu_method(end)=dmeth_params_set(md.qmu_method(end),...
    'max_iterations',10,...
    'max_function_evaluations',50,...
    'convergence_tolerance',0.01);

%%  a variety of parameters

md.qmu_params.evaluation_concurrency=4;
md.qmu_params.analysis_driver='';
md.qmu_params.analysis_components='';
md.qmu_params.interval_type='forward';
md.qmu_params.fd_gradient_step_size=0.01;

md.npart=10;

md.qmu
