function dvar=setupdrag(dvar,variables,params,varargin)

for i=1:length(varargin)
    if strcmp(class(varargin{i}),'model')
        md=varargin{i};
        break;
    end
end

%capture stddev:
stddev=variables.stddev;

if length(stddev)>md.npart,
	error('setupdrag error message: stddev should be either a scalar or a ''npart'' length vector');
end

%ok, dealing with semi-discrete distributed variable. Distribute according to how many 
%partitions we want

for j=1:md.npart
	dvar(end+1)           =variables;
	dvar(end  ).descriptor=sprintf('%s%d',variables.descriptor,j);
	if length(stddev)>1,
		dvar(end  ).stddev=stddev(j);
	end
end

end
