/*\file SparseToVector.cpp
 *\brief: extract from a sparse matlab matrix ir, jc, and other information 
 */

#include "./SparseToVector.h"

void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[] ) {
	
	int     i;
	
	/*Output: */
	mwIndex *ir =NULL;
	mwIndex *jc =NULL;
	double  *ird=NULL;
	double  *jcd=NULL;
	double   *pr=NULL;
	double   *prd=NULL;

	/* Check for proper number of arguments */
   
	if      (nrhs == 0 && nlhs == 0) {
		SparseToVectorUsage();
		return;
	}
	else if (nrhs <  1 || nlhs < 2 || nlhs > 6) {
		SparseToVectorUsage();
		mexErrMsgTxt(" ");
	}

	/* Create matrices for the return arguments */

	if (!mxIsNumeric(A_IN) || !mxIsSparse(A_IN)) {
		mexPrintf("%s -- Input matrix must be numeric and sparse.\n",__FUNCT__);
		mexErrMsgTxt(" ");
	}
	else {
		if (nlhs >= 4) {
			M_OUT    =mxCreateDoubleMatrix(1, 1, mxREAL);
			*mxGetPr(M_OUT)    =mxGetM(A_IN);
			if (nlhs >= 5) {
				N_OUT    =mxCreateDoubleMatrix(1, 1, mxREAL);
				*mxGetPr(N_OUT)    =mxGetN(A_IN);
				if (nlhs >= 6) {
					NZMAX_OUT=mxCreateDoubleMatrix(1, 1, mxREAL);
					*mxGetPr(NZMAX_OUT)=mxGetNzmax(A_IN);
				}
			}
		}
		if (mxGetNzmax(A_IN)) {
			ir    =mxGetIr(A_IN);
			IR_OUT=mxCreateDoubleMatrix(mxGetNzmax(A_IN), 1, mxREAL);
			ird = mxGetPr(IR_OUT);
			for (i=0; i<mxGetNzmax(A_IN); i++)
				ird[i]=(double)ir[i];
			if (nlhs >= 3) {
				pr    =mxGetPr(A_IN);
				PR_OUT=mxCreateDoubleMatrix(mxGetNzmax(A_IN), 1, mxREAL);
				prd = mxGetPr(PR_OUT);
				for (i=0; i<mxGetNzmax(A_IN); i++)
					prd[i]=(double)pr[i];
			}
		}
		else {
			IR_OUT=mxCreateDoubleMatrix(0, 0, mxREAL);
			if (nlhs >= 3) {
				PR_OUT=mxCreateDoubleMatrix(0, 0, mxREAL);
			}
		}
		if (mxGetN(A_IN)) {
			jc    =mxGetJc(A_IN);
			JC_OUT=mxCreateDoubleMatrix(mxGetN(A_IN)+1, 1, mxREAL);
			jcd = mxGetPr(JC_OUT);
			for (i=0; i<(mxGetN(A_IN)+1); i++)
				jcd[i]=(double)jc[i];
		}
		else {
			JC_OUT=mxCreateDoubleMatrix(0, 0, mxREAL);
		}
		mexPrintf("%s -- Input matrix is of size %d by %d with %d non-zeroes.\n",
				  __FUNCT__,mxGetM(A_IN),mxGetN(A_IN),mxGetNzmax(A_IN));
	}
}

void SparseToVectorUsage( void ){

    mexPrintf("\n");
    mexPrintf("Usage: [ir,jc,pr,m,n,nzmax]=SparseToVector(a);\n");
    mexPrintf("\n");
}

