/*!\file TriaRef.c
 * \brief: implementation of the TriaRef object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION TriaRef::TriaRef(){{{1*/
TriaRef::TriaRef(){
	this->element_type_list=NULL;
}
/*}}}*/
/*FUNCTION TriaRef::TriaRef(int* types,int nummodels){{{1*/
TriaRef::TriaRef(const int nummodels){

	/*Only allocate pointer*/
	element_type_list=(int*)xmalloc(nummodels*sizeof(int));

}
/*}}}*/
/*FUNCTION TriaRef::~TriaRef(){{{1*/
TriaRef::~TriaRef(){
	xfree((void**)&element_type_list);
}
/*}}}*/

/*Management*/
/*FUNCTION TriaRef::SetElementType{{{1*/
void TriaRef::SetElementType(int type,int type_counter){

	ISSMASSERT(type==P1Enum || type==P1DGEnum);

	/*initialize element type*/
	this->element_type_list[type_counter]=type;
}
/*}}}*/
