function output=ArchiveName(sequence)

%initialize string
output='Archive';

%loop over sequence
for i=1:length(sequence),

	%if string
	if ischar(sequence{i}),
		output=[output '_' sequence{i}];

	%else, make it a string
	else
		%if first or second, it is an Enum to be converted and shortened
		if (i<3),
			string=EnumAsString(sequence{i});
			string=string(1:end-8); %remove Analysis
			output=[output '_' ];
			for i=1:length(string),
				%Keep only capital letters + 3 letters (no numbers!)
				if strcmp(string(i),upper(string(i)))
					output=[output string(i:min(i+3,length(string)))];
				end
			end
		else
			output=[output '_' num2str(sequence{i})];
		end
	end
end
