%Dakota options
md.variables.nuv=normal_uncertain.empty();
md.variables.nuv(end+1)=normal_uncertain('RhoIce',md.rho_ice,0.01);
md.variables.nuv(end+1)=normal_uncertain('DragCoefficient',1,0.01);

md.responses=struct();
md.responses.rf =response_function.empty();
md.responses.rf (end+1)=response_function('max_vel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

md.qmu_method     =dakota_method('nond_l');

md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';
md.qmu_params.tabular_graphics_data=true;

%partitioning
md.npart=20;
md=partitioner(md,'package','chaco','npart',md.npart,'weighting','on');
md.part=md.part-1;
md.qmu_analysis=1;

md.eps_rel=10^-10; %tighten for qmu analyses
