
/*
	OutputDiagnostic.c: output model results for diagnostic solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputDiagnostic"

#include "../toolkits/toolkits.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"

void OutputDiagnostic(Vec u_g,Vec p_g, FemModel* femmodels,char* filename){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	/*intermediary: */
	FemModel  femmodel;
	NodeSets* nodesets=NULL;
	Vec       partition=NULL;
	char*     analysis_type="diagnostic";
	
	/* standard output: */
	Vec partition_shifted=NULL;
	double* serial_partition=NULL;

	double* serial_ug=NULL;
	int     one=1;
	int     gsize;
	int     nods;

	/*Recover diagnostic horiz femmodel: */
	femmodel=femmodels[0];
	partition=femmodel.partition;
	nodesets=femmodel.nodesets;

	/*serialize outputs: */
	VecDuplicate(partition,&partition_shifted);
	VecCopy(partition,partition_shifted);
	VecShift(partition_shifted,1.0); //matlab indexing starts at 1
	VecToMPISerial(&serial_partition,partition_shifted);
	VecGetSize(partition,&nods);

	VecToMPISerial(&serial_ug,u_g);

	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=pfopen(filename,"wb");

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write uset.gsize: */
		gsize=nodesets->GetGSize();
		WriteDataToDisk(&gsize,NULL,NULL,"Integer",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&nods,&one,"Mat",fid);
		
		/*Write solution to disk: */
		WriteDataToDisk(serial_ug,&gsize,&one,"Mat",fid);
	
		/*Close file: */
		pfclose(fid,filename);
	}

	/*Free ressources: */
	VecFree(&partition_shifted);
	xfree((void**)&serial_partition);
	xfree((void**)&serial_ug);
}	
