/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

/*objects: */
int NodeEnum(void);
int TriaEnum(void);
int SingEnum(void);
int BeamEnum(void);
int PentaEnum(void);
int MaterialEnum(void);
int MaticeEnum(void);
int MatparEnum(void);
int SpcEnum(void);
int PenpairEnum(void);
int PengridEnum(void);
int IcefrontEnum(void);
int ParamEnum(void);
int ElementEnum(void);
int LoadEnum(void);
int RgbEnum(void);
int InputEnum(void);

/*formulations: */
int NoneEnum(void);
int HutterEnum(void);
int MacAyealEnum(void);
int PattynEnum(void);
int StokesEnum(void);

/* analysis enums: */
int DiagnosticAnalysisEnum(void);
int ControlAnalysisEnum(void);
int ThermalAnalysisEnum(void);
int PrognosticAnalysisEnum(void);
int MeltingAnalysisEnum(void);
int SlopeComputeAnalysisEnum(void);
int StokesAnalysisEnum(void);
int HutterAnalysisEnum(void);
int SurfaceXAnalysisEnum(void);
int SurfaceYAnalysisEnum(void);
int BedXAnalysisEnum(void);
int BedYAnalysisEnum(void);
int HorizAnalysisEnum(void);
int VertAnalysisEnum(void);
int NoneAnalysisEnum(void);
int SteadyAnalysisEnum(void);
int TransientAnalysisEnum(void);


/*datasets: */
int ElementsEnum(void);
int NodesEnum(void);
int ConstraintsEnum(void);
int LoadsEnum(void);
int MaterialsEnum(void);
int ParametersEnum(void);

/*Functions on enums: */
int EnumIsElement(int en);
int EnumIsLoad(int en);
int EnumIsMaterial(int en);
int AnalysisTypeAsEnum(char* analysis_type);
#endif
