/*!\file InputConvergencex
 */

#include "./InputConvergencex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

int InputConvergencex(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,int* enums, int num_enums, int* criterionenums, double* criterionvalues,int num_criterionenums){

	/*intermediary:*/
	int         i;
	int         converged = 1;
	int         node_converged=1;
	double     *eps       = NULL;
	extern int  my_rank;
	int         rank_allowed;
	Element*    element=NULL;
	int         verbose=0;

	/*retrieve parameters: */
	parameters->FindParam(&verbose,VerboseEnum);
	
	/*allocate dynamic memory: */
	eps=(double*)xmalloc(num_criterionenums*sizeof(double));

	/*Go through elements, and ask them to do the job: */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->InputConvergence(&converged,eps,enums,num_enums,criterionenums,criterionvalues,num_criterionenums);
		if(!converged)break;
	}

	if(!converged){ 
		/*get convergence information to user: */
		if(verbose>2)rank_allowed=my_rank;
		else rank_allowed=0;
		if(my_rank==rank_allowed){
			printf("Convergence info: element %i (and maybe others) did not converge for inputs:",element->Id());
			for(i=0;i<num_enums-1;i++)printf(" %s,",EnumAsString(enums[i])); printf(" %s\n",EnumAsString(enums[num_enums-1]));
			printf("                  convergence criterions: ");
			for(i=0;i<num_criterionenums;i++) printf("%s: %g/%g ",EnumAsString(criterionenums[i]),eps[i],criterionvalues[i]);
			printf("\n");
		}
	}
	
	/*In parallel, we need to gather the converged status: */
	#ifdef _PARALLEL_
	MPI_Reduce (&converged,&node_converged,1,MPI_INT,MPI_MIN,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_converged,1,MPI_INT,0,MPI_COMM_WORLD);   
	converged=node_converged;
	#endif

	/*Free ressources:*/
	xfree((void**)&eps);

	/*return: */
	return converged;
}
