function [field_names field_values]=testsgetfields(md,sequence),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'prognostic.thickness'
%
%   Usage:
%      [field_names field_values]=testsgetfields(md,analysis)
%
%   Example:
%      [field_names field_values]=testsgetfields(md,'DiagnosticSolution')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

%recover what is being requested.
analysis_type=sequence{1};
sub_analysis_type=sequence{2};
qmu=sequence{3};
control=sequence{4};
control_fit=sequence{5};
parallel=sequence{6};

if (analysis_type==DiagnosticSolutionEnum),
	if control,
		field_names={'Vel','J','parameter'};
		vel=zeros(md.numberofgrids,1);
		vel(md.results.DiagnosticSolution.Vel.index)=md.results.DiagnosticSolution.Vel.value;
		j=md.results.DiagnosticSolution.J;
		parameter=zeros(md.numberofgrids,1);
		if strcmpi(md.control_type,'rheology_B'),
			parameter(md.results.DiagnosticSolution.RheologyB.index)=md.results.DiagnosticSolution.RheologyB.value;
		elseif strcmpi(md.control_type,'drag_coefficient'),
			parameter(md.results.DiagnosticSolution.DragCoefficient.index)=md.results.DiagnosticSolution.DragCoefficient.value;
		else
			error('not implemented yet');
		end
		field_values={vel,j,parameter};
	elseif qmu,
		field_names={'importancefactors'};
		field_values={md.results.dakota.importancefactors};
	else
		if md.dim==3
			field_names={'Vy','Vz'};
			vy=zeros(md.numberofgrids,1);
			vy(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
			vz=zeros(md.numberofgrids,1);
			vz(md.results.DiagnosticSolution.Vz.index)=md.results.DiagnosticSolution.Vz.value;
			field_values={vy,vz};
		else
			field_names={'Vel'};
			vel=zeros(md.numberofgrids,1);
			vel(md.results.DiagnosticSolution.Vel.index)=md.results.DiagnosticSolution.Vel.value;
			field_values={vel};
		end
	end

elseif (analysis_type==ThermalSolutionEnum),
	field_names={'Temperature','MeltingRate'};
	temperature=zeros(md.numberofgrids,1);
	temperature(md.results.ThermalSolution(end).Temperature.index)=md.results.ThermalSolution(end).Temperature.value;
	melting=zeros(md.numberofgrids,1);
	melting(md.results.ThermalSolution(end).MeltingRate.index)=md.results.ThermalSolution(end).MeltingRate.value;
	field_values={temperature,melting};

elseif (analysis_type==PrognosticSolutionEnum),
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.PrognosticSolution.Thickness.index)=md.results.PrognosticSolution.Thickness.value;
	field_values={thickness};

elseif (analysis_type==Prognostic2SolutionEnum),
	field_names={'Thickness'};
	thickness   =zeros(md.numberofgrids,1);
	connectivity=sparse(md.results.Prognostic2Solution.Thickness.index(:),1,1);
	thickness   =sparse(md.results.Prognostic2Solution.Thickness.index(:),1,md.results.Prognostic2Solution.Thickness.value(:));
	thickness=full(thickness./connectivity);
	field_values={thickness};

elseif (analysis_type==Transient2DSolutionEnum), 
	field_names={'Vel','Thickness','Surface','Bed'};
	vel=zeros(md.numberofgrids,1);
	vel(md.results.Transient2DSolution(end).Vel.index)=md.results.Transient2DSolution(end).Vel.value;
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.Transient2DSolution(end).Thickness.index)=md.results.Transient2DSolution(end).Thickness.value;
	surface=zeros(md.numberofgrids,1);
	surface(md.results.Transient2DSolution(end).Surface.index)=md.results.Transient2DSolution(end).Surface.value;
	bed=zeros(md.numberofgrids,1);
	bed(md.results.Transient2DSolution(end).Bed.index)=md.results.Transient2DSolution(end).Bed.value;
	field_values={vel,thickness,surface,bed};

elseif (analysis_type==Transient3DSolutionEnum), 
	field_names={'Vel','Pressure','Temperature','MeltingRate','Thickness','Surface','Bed'};
	vel=zeros(md.numberofgrids,1);
	vel(md.results.Transient3DSolution(end).Vel.index)=md.results.Transient3DSolution(end).Vel.value;
	pressure=zeros(md.numberofgrids,1);
	pressure(md.results.Transient3DSolution(end).Pressure.index)=md.results.Transient3DSolution(end).Pressure.value;
	temperature=zeros(md.numberofgrids,1);
	temperature(md.results.Transient3DSolution(end).Temperature.index)=md.results.Transient3DSolution(end).Temperature.value;
	melting=zeros(md.numberofgrids,1);
	melting(md.results.Transient3DSolution(end).MeltingRate.index)=md.results.Transient3DSolution(end).MeltingRate.value;
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.Transient3DSolution(end).Thickness.index)=md.results.Transient3DSolution(end).Thickness.value;
	surface=zeros(md.numberofgrids,1);
	surface(md.results.Transient3DSolution(end).Surface.index)=md.results.Transient3DSolution(end).Surface.value;
	bed=zeros(md.numberofgrids,1);
	bed(md.results.Transient3DSolution(end).Bed.index)=md.results.Transient3DSolution(end).Bed.value;
	field_values={vel,pressure,temperature,melting,thickness,surface,bed};

elseif (analysis_type==SteadystateSolutionEnum), 
	if control,
		field_names={'Vel','J','parameter'};
		vel=zeros(md.numberofgrids,1);
		vel(md.results.SteadystateSolution.Vel.index)=md.results.SteadystateSolution.Vel.value;
		j=md.results.SteadystateSolution.J;
		parameter=zeros(md.numberofgrids,1);
		if strcmpi(md.control_type,'rheology_B'),
			parameter(md.results.SteadystateSolution.RheologyB.index)=md.results.SteadystateSolution.RheologyB.value;
		elseif strcmpi(md.control_type,'drag_coefficient'),
			parameter(md.results.SteadystateSolution.DragCoefficient.index)=md.results.SteadystateSolution.DragCoefficient.value;
		else
			error('not implemented yet');
		end
		field_values={vel,j,parameter};
	else
		field_names={'Vel','Pressure','Temperature'};
		vel=zeros(md.numberofgrids,1);
		vel(md.results.SteadystateSolution.Vel.index)=md.results.SteadystateSolution.Vel.value;
		pressure=zeros(md.numberofgrids,1);
		pressure(md.results.SteadystateSolution.Pressure.index)=md.results.SteadystateSolution.Pressure.value;
		temperature=zeros(md.numberofgrids,1);
		temperature(md.results.SteadystateSolution.Temperature.index)=md.results.SteadystateSolution.Temperature.value;
		field_values={vel,pressure,temperature};
	end

elseif (analysis_type==BalancedthicknessSolutionEnum), 
	field_names={'Thickness'};
	thickness=zeros(md.numberofgrids,1);
	thickness(md.results.BalancedthicknessSolution.Thickness.index)=md.results.BalancedthicknessSolution.Thickness.value;
	field_values={thickness};

elseif (analysis_type==SurfaceSlopeSolutionEnum), 
	field_names={'SlopeX','SlopeY'};
	slopex=zeros(md.numberofgrids,1);
	slopex(md.results.SurfaceSlopeSolution.SurfaceSlopeX.index)=md.results.SurfaceSlopeSolution.SurfaceSlopeX.value;
	slopey=zeros(md.numberofgrids,1);
	slopey(md.results.SurfaceSlopeSolution.SurfaceSlopeY.index)=md.results.SurfaceSlopeSolution.SurfaceSlopeY.value;
	field_values={slopex,slopey};

elseif (analysis_type==BedSlopeSolutionEnum), 
	field_names={'SlopeX','SlopeY'};
	slopex=zeros(md.numberofgrids,1);
	slopex(md.results.BedSolution.BedSlopeX.index)=md.results.BedSolution.BedSlopeX.value;
	slopey=zeros(md.numberofgrids,1);
	slopey(md.results.BedSolution.BedSlopeY.index)=md.results.BedSolution.BedSlopeY.value;
	field_values={slopex,slopey};

else
	error(['testsgetfields error message: requested sequence not supported yet']);
end
