function plot_parthist(md,options,nlines,ncols,i);
%PLOT_MESH - plot partitioning histogram
%
%   Usage:
%      plot_mesh(md,options,nlines,ncols,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,[],options);

%plot mesh
subplot(nlines,ncols,i); 

imin=min(md.part);
imax=max(md.part);

part=zeros(imax-imin+1,2);

for i=imin:imax
    ind=find(md.part == i);
    part(i-imin+1,1)=length(ind);
	part(i-imin+1,2)=sum(md.vwgt(ind));
end

subplot(2,1,1)
bar(imin:imax,part(:,1));
xlim([imin imax])
title('Number of Nodes in Each Partition')

subplot(2,1,2)
bar(imin:imax,part(:,2));
xlim([imin imax])
title('Weight of Nodes in Each Partition')
