function [u_g p_g]=diagnostic_core(m_dh,m_dhu,m_dv,m_ds,m_sl,inputs);
%DIAGNOSTIC_CORE - compute the core velocity field 
%
%   Usage:
%      u_g=diagnostic_core(m_dh,m_dhu,m_dv,m_ds,m_sl,inputs);
%

%recover parameters common to all solutions
debug=m_dhu.parameters.debug;
dim=m_dhu.parameters.dim;
ishutter=m_dhu.parameters.ishutter;
ismacayealpattyn=m_dh.parameters.ismacayealpattyn;
isstokes=m_ds.parameters.isstokes;

if ishutter,

	displaystring(debug,'\n%s',['computing surface slope (x and y derivatives)...']);
	slopex=diagnostic_core_linear(m_sl,inputs,'slope_compute','surfacex');
	slopey=diagnostic_core_linear(m_sl,inputs,'slope_compute','surfacey');

	if dim==3,
		displaystring(debug,'\n%s',['extruding slopes in 3d...']);
		slopex=SlopeExtrude(m_sl.elements,m_sl.nodes,m_sl.loads,m_sl.materials,slopex);
		slopey=SlopeExtrude(m_sl.elements,m_sl.nodes,m_sl.loads,m_sl.materials,slopey);
	end

	displaystring(debug,'\n%s',['computing slopes...']);
	inputs=add(inputs,'surfaceslopex',slopex,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);
	inputs=add(inputs,'surfaceslopey',slopey,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);

	displaystring(debug,'\n%s',['computing hutter velocities...']);
	u_g=diagnostic_core_linear(m_dhu,inputs,'diagnostic','hutter');

	displaystring(debug,'\n%s',['computing pressure according to MacAyeal...']);
	p_g=ComputePressure(m_dhu.elements,m_dhu.nodes,m_dhu.loads,m_dhu.materials,m_dhu.parameters);

	displaystring(debug,'\n%s',['update boundary conditions for macyeal pattyn using hutter results...']);
	if ismacayealpattyn,
		m_dh.y_g=u_g;
		[m_dh.ys m_dh.ys0]=Reducevectorgtos(m_dh.y_g,m_dh.nodesets);
	end

end
		
if ismacayealpattyn,

	displaystring(debug,'\n%s',['computing horizontal velocities...']);
	u_g=diagnostic_core_nonlinear(m_dh,inputs,'diagnostic','horiz');

	displaystring(debug,'\n%s',['computing pressure according to MacAyeal...']);
	p_g=ComputePressure(m_dh.elements,m_dh.nodes,m_dh.loads,m_dh.materials,m_dh.parameters);
end
	
if dim==3,

	displaystring(debug,'\n%s',['extruding horizontal velocities...']);
	u_g_horiz=VelocityExtrude(m_dh.elements,m_dh.nodes,m_dh.loads,m_dh.materials,u_g);

	displaystring(debug,'\n%s',['computing vertical velocities...']);
	inputs=add(inputs,'velocity',u_g_horiz,'doublevec',m_dh.parameters.numberofdofspernode,m_dh.parameters.numberofnodes);
	u_g_vert=diagnostic_core_linear(m_dv,inputs,'diagnostic','vert');

	displaystring(debug,'\n%s',['combining horizontal and vertical velocities...']);
	u_g=zeros(m_dh.parameters.numberofnodes*3,1);
	u_g(dofsetgen([1,2],3,m_dh.parameters.numberofnodes*3))=u_g_horiz;
	u_g(dofsetgen([3],3,m_dh.parameters.numberofnodes*3))=u_g_vert;

	displaystring(debug,'\n%s',['computing pressure according to Pattyn...']);
	p_g=ComputePressure(m_dh.elements,m_dh.nodes,m_dh.loads,m_dh.materials,m_dh.parameters);
	
	if isstokes,

		%"recondition" pressure 
		p_g=p_g/m_ds.parameters.stokesreconditioning;

		displaystring(debug,'\n%s',['computing bed slope (x and y derivatives)...']);
		slopex=diagnostic_core_linear(m_sl,inputs,'slope_compute','bedx');
		slopey=diagnostic_core_linear(m_sl,inputs,'slope_compute','bedy');
		slopex=SlopeExtrude(m_sl.elements,m_sl.nodes,m_sl.loads,m_sl.materials,slopex);
		slopey=SlopeExtrude(m_sl.elements,m_sl.nodes,m_sl.loads,m_sl.materials,slopey);

		inputs=add(inputs,'bedslopex',slopex,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);
		inputs=add(inputs,'bedslopey',slopey,'doublevec',m_sl.parameters.numberofdofspernode,m_sl.parameters.numberofnodes);
		
		%recombine u_g and p_g: 
		u_g_stokes=zeros(m_ds.nodesets.gsize,1);
		u_g_stokes(dofsetgen([1,2,3],4,m_ds.nodesets.gsize))=u_g;
		u_g_stokes(dofsetgen([4],4,m_ds.nodesets.gsize))=p_g;

		inputs=add(inputs,'velocity',u_g_stokes,'doublevec',4,m_ds.parameters.numberofnodes);

		displaystring(debug,'\n%s',['update boundary conditions for stokes using velocities previously computed...']);
		m_ds.y_g(dofsetgen([1,2,3],4,m_ds.nodesets.gsize))=u_g;
		[m_ds.ys m_ds.ys0]=Reducevectorgtos(m_ds.y_g,m_ds.nodesets);

		displaystring(debug,'\n%s',['computing stokes velocities and pressure ...']);
		u_g=diagnostic_core_nonlinear(m_ds,inputs,'diagnostic','stokes');
	
		%"decondition" pressure
		p_g=u_g(4:4:end)*m_dh.parameters.stokesreconditioning;
	end
end
