/*\file MaterialUpdateFromTemperature.c
 *\brief: update B from T
 */

#include "./MaterialUpdateFromTemperature.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Loads      *loads      = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MaterialUpdateFromTemperatureUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	MaterialUpdateFromTemperaturex( elements, nodes, vertices, loads, materials,parameters);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);
	WriteData(MATERIALSOUT,materials);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void MaterialUpdateFromTemperatureUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,materials] = %s(elements, nodes, vertices, loads, materials, parameters);\n",__FUNCT__);
	_printf_("\n");
}
