/*! \file BeamVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BEAMVERTEXINPUT_H_
#define _BEAMVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/


class BeamVertexInput: public Input{

	public:
		/*just hold 2 values for 2 vertices: */
		int    enum_type;
		double values[2];

		/*BeamVertexInput constructors, destructors: {{{1*/
		BeamVertexInput();
		BeamVertexInput(int enum_type,double* values);
		~BeamVertexInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*BeamVertexInput management: {{{1*/
		int   EnumType();
		Input* SpawnSingInput(int  index);
		Input* SpawnBeamInput(int* indices);
		Input* SpawnTriaInput(int* indices);
		Input* SpawnProcessedInput(double (*f)(double)){ISSMERROR("not implemented yet");};
		Input* PointwiseDivide(Input* inputB){ISSMERROR("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterAverage(double* pvalue);
	
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void Scale(double scale_factor);
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		void Extrude(void){ISSMERROR("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){ISSMERROR("not supported yet");};
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _BEAMVERTEXINPUT_H */
