/*!\file MaterialUpdateFromTemperaturex
 * \brief: transfer an input to the results  dataset inside the elements
 */

#include "./MaterialUpdateFromTemperaturex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaterialUpdateFromTemperaturex(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters){

	/*intermediary:*/
	int      i;
	Element *element = NULL;

	/*Go through elemnets, and ask each element to update their material*/
	for(i=0;i<elements->Size();i++){

		element=(Element*)elements->GetObjectByOffset(i);
		element->MaterialUpdateFromTemperature();
	}

}
