/*!\file:  GradJCompute.cpp
 * \brief compute inverse method gradient direction.
 */ 

#include "../issm.h"
#include "./parallel.h"

#undef __FUNCT__ 
#define __FUNCT__ "GradJCompute"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

Vec GradJCompute(ParameterInputs* inputs,FemModel* femmodel,double* u_g_obs){
	
	
	/*intermediary: */
	int analysis_type;
	char* solver_string=NULL;
	char* control_type=NULL;
	
	Vec u_g=NULL;
	double* u_g_double=NULL;

	Vec du_g=NULL;
	Vec du_f=NULL;

	Vec lambda_f=NULL;
	Vec lambda_g=NULL;
	double* lambda_g_double=NULL;

	Mat K_ff0=NULL;
	Mat K_fs0=NULL;
	
	/*output: */
	Vec grad_g=NULL;

	
	/*some parameters:*/
	femmodel->parameters->FindParam((void*)&analysis_type,"analysis_type");
	femmodel->parameters->FindParam((void*)&solver_string,"solver_string");
	femmodel->parameters->FindParam((void*)&control_type,"control_type");

	_printf_("%s\n","   Recover solution for this stiffness and right hand side: \n");
	diagnostic_core_nonlinear(&u_g,&K_ff0,&K_fs0,inputs,femmodel);
	VecToMPISerial(&u_g_double,u_g); VecFree(&u_g);

	_printf_("%s\n","   Buid Du, difference between observed velocity and model velocity:\n");
	Dux( &du_g, femmodel->elements,femmodel->nodes,femmodel->loads,femmodel->materials,u_g_double,u_g_obs, inputs,analysis_type);

	_printf_("%s\n","   Reduce adjoint load from g-set to f-set:\n");
	Reduceloadfromgtofx(&du_f, du_g, femmodel->Gmn, K_fs0, femmodel->ys0, femmodel->nodesets);
	VecFree(&du_g);MatFree(&K_fs0);

	_printf_("%s\n","   Solve for adjoint vector: \n");
	Solverx(&lambda_f, K_ff0, du_f, NULL, solver_string);
	VecFree(&du_f); MatFree(&K_ff0);
	
	_printf_("%s\n","   Merge back to g set:\n");
	Mergesolutionfromftogx(&lambda_g, lambda_f,femmodel->Gmn,femmodel->ys0,femmodel->nodesets);
	VecFree(&lambda_f);

	_printf_("%s\n","   Compute gradJ:\n");
	VecToMPISerial(&lambda_g_double,lambda_g);VecFree(&lambda_g);

	Gradjx( &grad_g, femmodel->elements,femmodel->nodes, femmodel->loads, femmodel->materials, 
		u_g_double,lambda_g_double, inputs,analysis_type,control_type);
	
	/*Free ressources:*/
	xfree((void**)&solver_string);
	xfree((void**)&control_type);
	xfree((void**)&u_g_double);
	xfree((void**)&lambda_g_double);

	return grad_g;

}
