function md=diagnostic_proto(md);
%DIAGNOSTIC - compute the velocity field of a model
%   Usage:
%      md=diagnostic(md)
%

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	displaystring(md.debug,'%s',['reading diagnostic horiz model data']);
	md.analysis_type='diagnostic'; md.sub_analysis_type='horiz'; m_dh=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading diagnostic vert model data']);
	md.analysis_type='diagnostic'; md.sub_analysis_type='vert'; m_dv=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading diagnostic stokes model data']);
	md.analysis_type='diagnostic'; md.sub_analysis_type='stokes'; m_ds=CreateFemModel(md);

	displaystring(md.debug,'\n%s',['reading diagnostic hutter model data']);
	md.analysis_type='diagnostic'; md.sub_analysis_type='hutter'; m_dhu=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading surface and bed slope computation model data']);
	md.analysis_type='slope_compute'; md.sub_analysis_type=''; m_sl=CreateFemModel(md);
	
	% figure out number of dof: just for information purposes.
	md.dof=modelsize(m_dh,m_dv,m_ds,m_dhu,m_sl);

	%initialize inputs
	inputs=inputlist;
	inputs=add(inputs,'velocity',m_dh.parameters.u_g,'doublevec',3,m_dh.parameters.numberofnodes);

	%compute solution
	[u_g,p_g]=diagnostic_core(m_dh,m_dhu,m_dv,m_ds,m_sl,inputs);

	%Load results onto model
	md=loadresults(md,u_g,p_g,m_dh,m_ds,m_dhu);

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
