function md=loadresultsfromcluster(md)
%LOADRESULTSFROMCLUSTER - load results of solution sequence from cluster
%
%   Usage:
%      md=loadresultsfromcluster(md);

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%if we are running locally, no need to call ssh to recover the logs and results. We figure out by comparing the 
%hostname to the cluster name
[result,hostname]=system('hostname -s');hostname=hostname(1:end-1);

%Go pickup output file and logs on cluster
if strcmpi(hostname,md.cluster),
	system(['cp ' executionpath '/' md.name '.*o* ./']); %get outlog, errlog and outbin files
else
	system(['scp ' md.cluster ':' executionpath '/' md.name '.*o* ./']); %get outlog, errlog and outbin files
end

%read log files onto  fields
md.errlog=readfile([md.name '.errlog']);
md.outlog=readfile([md.name '.outlog']);

if ~isempty(md.errlog),
	disp(['loadresultsfromcluster info message: error during solution. Check your errlog and outlog model fields']);
end

%If we are here, no errors in the solution sequence, call loadresultsfromdisk.
md=loadresultsfromdisk(md,[md.name '.outbin'],md.analysis_type);

%erase the log and output files
system(['rm -rf ' md.name '.outlog ' md.name '.errlog' md.name '.outbin']);
