/*!\file:  OptFunc.cpp
 * \brief: "C" code wrapper to matlab objectivefunctionC call
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "OptFunc"


#ifdef _SERIAL_
#include "mex.h"
double OptFunc(double scalar, OptArgs* optargs){
	
	/*output: */
	double J;

	mxArray*   inputs[9];
	mxArray*   psearch_scalar=NULL;
	mxArray*   mxJ=NULL;


	psearch_scalar=mxCreateDoubleScalar(scalar);
	inputs[0]=psearch_scalar;
	inputs[1]=optargs->m;
	inputs[2]=optargs->inputs;
	inputs[3]=optargs->p_g;
	inputs[4]=optargs->u_g_obs;
	inputs[5]=optargs->grad_g;
	inputs[6]=optargs->n;
	inputs[7]=optargs->analysis_type;
	inputs[8]=optargs->sub_analysis_type;

	mexCallMATLAB( 1, &mxJ, 9, (mxArray**)inputs, optargs->function_name);

	/*extract misfit from mxArray*/
	J=mxGetScalar(mxJ);

	return J;
}
#else
double OptFunc(double scalar, OptArgs* optargs){
	throw ErrorException(__FUNCT__," not implemented yet");
}
#endif
