/*!\file: diagnostic_core_nonlinear.cpp
 * \brief: core of the diagnostic solution for non linear materials
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "diagnostic_core_inear"

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../issm.h"

void diagnostic_core_linear(Vec* pug,FemModel* fem,ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	/*parameters:*/
	int kflag,pflag,connectivity,numberofdofspernode;
	int debug=0;
	char* solver_string=NULL;

	/*output: */
	Vec ug=NULL;
	Vec uf=NULL; 
	
	/*intermediary: */
	Mat Kgg=NULL;
	Mat Kff=NULL;
	Mat Kfs=NULL;
	Vec pg=NULL;
	Vec pf=NULL;

	/*Recover parameters: */
	kflag=1; pflag=1;
	fem->parameters->FindParam((void*)&connectivity,"connectivity");
	fem->parameters->FindParam((void*)&numberofdofspernode,"numberofdofspernode");
	fem->parameters->FindParam((void*)&debug,"debug");
	fem->parameters->FindParam((void*)&solver_string,"solverstring");

	/*Update parameters: */
	UpdateFromInputsx(fem->elements,fem->nodes,fem->loads, fem->materials,inputs);
		
	//*Generate system matrices
	if (debug) _printf_("   Generating matrices\n");
	SystemMatricesx(&Kgg, &pg,fem->elements,fem->nodes,fem->loads,fem->materials,kflag,pflag,connectivity,numberofdofspernode,inputs,analysis_type,sub_analysis_type); 

	/*!Reduce matrix from g to f size:*/
	if (debug) _printf_("   reducing matrix from g to f set\n");
	Reducematrixfromgtofx(&Kff,&Kfs,Kgg,fem->Gmn,fem->nodesets);

	/*!Reduce load from g to f size: */
	if (debug) _printf_("   reducing load from g to f set\n");
	Reduceloadfromgtofx(&pf, pg, fem->Gmn, Kfs, fem->ys, fem->nodesets);

	/*Solve: */
	if (debug) _printf_("   solving\n");
	Solverx(&uf, Kff, pf, NULL, solver_string);

	//Merge back to g set
	if (debug) _printf_("   merging solution from f to g set\n");
	Mergesolutionfromftogx(&ug, uf,fem->Gmn,fem->ys,fem->nodesets);

	/*Assign output pointers:*/
	*pug=ug;
}
