/*!\file Pengrid.h
 * \brief: header file for pengrid object */

#ifndef _PENGRID_H_
#define _PENGRID_H_

#include "./Load.h"
#include "./Node.h"
#include "./Element.h"

class Element;
class Pengrid: public Load{

	private: 

		int		id;
		int     dof;
		int     active;
		double  penalty_offset; 
		int     thermal_steadystate;
		
		/*nodes: */
		int     node_id;
		Node*   node;
		int     node_offset;

	public:

		Pengrid();
		Pengrid(int	id, int node_id,int dof, int active, double penalty_offset,int thermal_steadystate);
		~Pengrid();

		void  Echo();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type,int sub_analysis_type);
		void  Configure(void* elements,void* nodes,void* materials);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixDiagnosticStokes(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofspernode);
		Object* copy();

};

#endif  /* _PENGRID_H_ */


