/*!\file PenaltyConstraintsx
 * \brief: set up penalty constraints on loads
 */

#include "./PenaltyConstraintsx.h"

#undef __FUNCT__ 
#define __FUNCT__ "PenaltyConstraintsx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void PenaltyConstraintsx(int* pconverged, int* pnum_unstable_constraints, DataSet* elements,DataSet* nodes,
		DataSet* loads,DataSet* materials, ParameterInputs* inputs,int analysis_type,int sub_analysis_type){

	int i;

	extern int num_procs;
	extern int my_rank;
	
	/*output: */
	int converged=0;
	int num_unstable_constraints=0;

	/*First, get loads configured: */
	loads->Configure(elements, loads, nodes, materials);

	/*Do we have penalties linked to rifts? In this case, run our special rifts penalty 
	 * management routine, otherwise, skip : */
	if (loads->RiftIsPresent()){
		loads->RiftConstraints(&num_unstable_constraints,inputs,analysis_type,sub_analysis_type);
	}
	else if(loads->MeltingIsPresent()){
		loads->MeltingConstraints(&num_unstable_constraints,inputs,analysis_type,sub_analysis_type);
	}
	else{
		/*Do nothing, no constraints management!:*/
		num_unstable_constraints=0;
	}

	/*Have we converged? : */
	if (num_unstable_constraints==0) converged=1;
	else converged=0;
	
	/*Assign output pointers: */
	*pconverged=converged;
	*pnum_unstable_constraints=num_unstable_constraints;
	
}
