/*!\file Misfitx
 * \brief: compute misfit between observations and model
 */

#include "./Misfitx.h"

#undef __FUNCT__ 
#define __FUNCT__ "Misfitx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void Misfitx( double* pJ, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials, 
		double* u_g, double* u_g_obs, ParameterInputs* inputs,int analysis_type,int sub_analysis_type){
	
	/*output: */
	double J;
	double J_sum;
	
	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes, materials);

	/*Compute gradients: */
	elements->Misfit(&J, u_g,u_g_obs,inputs,analysis_type,sub_analysis_type);

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&J,&J_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&J_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	J=J_sum;

	/*Assign output pointers: */
	*pJ=J;
}
