#!/bin/bash

# Some cleanup
rm -rf Chaco-2.2
rm -rf src 
rm -rf install 

# Create src and install directories
mkdir src install 

# Untar 
tar -xvzf Chaco-2.2.tar.gz

# Move chaco to src directory
mv Chaco-2.2/* src
rm -rf Chaco-2.2

# Apply patches (all at once)
# (written by diff -rc src ~/Libs/Chaco-2.2 > chaco.patch)
patch -p0 < chaco.patch

# Build chaco
cd src/code
make
# Clean up objects (but not library or executable)
make clean
cd ../..

# Populate install directory
cp -p src/exec/README install
cp -p src/exec/User_Params install
cp -p src/exec/*.coords install
cp -p src/exec/*.graph install
mv src/exec/chaco install

