function md=loadresultsfromdisk(md,filename,solutiontype)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%We convert all results to m/a units, from m/s

if ((nargin~=3) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end


results=parseresultsfromdisk(filename);

%First get solution type
analysis_type=results{1};

%Get gsize
gsize=results{2};

%Get part
part=results{3};

%now to specialized reading
if strcmpi(analysis_type,'diagnostic'),

	%Get u_g
	u_g=results{4};

	if strcmpi(md.type,'2d'),
		%Used to recover velocities
		indx=1:2:gsize;
		indy=2:2:gsize;
		indx=indx(part);
		indy=indy(part);

		%Recover velocity
		md.vx=u_g(indx)*md.yts;
		md.vy=u_g(indy)*md.yts;
		md.vel=sqrt(md.vx.^2+md.vy.^2);
	else
		%Used to recover velocities
		indx=1:3:gsize;
		indy=2:3:gsize;
		indz=3:3:gsize;
		indx=indx(part);
		indy=indy(part);
		indz=indz(part);

		%Recover velocity
		md.vx=u_g(indx)*md.yts;
		md.vy=u_g(indy)*md.yts;
		md.vz=u_g(indz)*md.yts;
		md.vel=sqrt(md.vx.^2+md.vy.^2+md.vz.^2);
	end

elseif strcmpi(analysis_type,'control'),

	%Get u_g
	u_g=results{4};

	%Used to recover velocities
	indx=1:2:gsize;
	indy=2:2:gsize;
	indx=indx(part);
	indy=indy(part);

	%Recover velocity
	md.cont_vx=u_g(indx)*md.yts;
	md.cont_vy=u_g(indy)*md.yts;
	md.cont_vel=sqrt(md.cont_vx.^2+md.cont_vy.^2);
	
	%recover parameter 
	cont_parameter=results{5};
	cont_parameter=cont_parameter(indx);
	md.cont_parameter=cont_parameter;
	
	%read J
	if(md.nsteps~=results{6}),
		error('output from control method incompatible with model');
	end
	md.cont_J=results{7};

elseif strcmpi(analysis_type,'thermalsteady'),

	%read t_g
	t_g=results{4};

	%Used to recover velocities
	indx=1:6:gsize;
	indx=indx(part);

	%Recover velocity
	md.temperature=t_g(indx);
else
	error(['loadresultsfromdisk error message: unknow solution type ',analysis_type]);
end


%Check result is consistent
disp(sprintf('%s\n','checking result consistency'));

if ~isresultconsistent(md,solutiontype),
	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
end
