function displaysolutionparameters(md)
%DISPLAYSOLUTIONPARAMETERS - display solution parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaysolutionparameters(md)

disp(sprintf('   Solution parameters:'));
disp(sprintf('      ''%s''','statics'));
disp(sprintf('         %s','Newton convergence criteria'));
disp(sprintf('            eps_rel: %g      (velocity relative convergence criterion)',md.eps_rel));
disp(sprintf('            eps_abs: %g      (velocity absolute convergence criterion [m/yr], NaN -> no absolute criterion)',md.eps_abs));
disp(sprintf('            viscosity_overshoot: %g      (over-shooting constant new=new+C*(new-old))',md.viscosity_overshoot));
disp(sprintf('         penalty_offset: %g      (offset used by penalties: penalty = Kmax*10^offset)',md.penalty_offset));
disp(sprintf('         penalty_melting: %g      (penalty used to keep T<Tpmp)',md.penalty_melting));
disp(sprintf('         penalty_lock: %g      (counter used to lock penalties that zig zag)',md.penalty_lock));
disp(sprintf('         lowmem: %i      (Set to 1 if you are running low on cluster memory)',md.lowmem));
disp(sprintf('         sparsity: %g      (matrix sparsity. Set to .001 for < 1M dof, .0001 for 5M dof, and .00001 for > 10M dof',md.sparsity));
disp(sprintf('         connectivity: %i      (element connectivity)',md.connectivity)); 
disp(sprintf('         debug: %i      (output debug statements when possible yes-> 1, no -> 0. Default is 1',md.debug));
disp(sprintf('         element_debug: %i      (output debug statements for elementswhen possible yes-> 1, no -> 0. Default is 0',md.element_debug));
disp(sprintf('         element_debugid: %i      (if element_debug on, id of element for which to output messages',md.element_debugid));
disp(sprintf('         debug: %i      (output debug statements when possible yes-> 1, no -> 0. Default is 1'));
disp(sprintf('      ''%s''','transient'));
disp(sprintf('         dt: %g ( time step in years)',md.dt/md.yts));
disp(sprintf('         ndt: %g ( time span in years)',md.ndt/md.yts));
disp(sprintf('         artificial_diffusivity: %i (yes->1, no->0)',md.artificial_diffusivity));
disp(sprintf('         minh: %g (minimum thickness to avoid stiffness singularity)',md.minh));
disp(sprintf('         timestepping: %i ( adptative time stepping implemented - default to 0)',md.timestepping));
disp(sprintf('         deltaH: %g ( minimum thickness difference between two time steps)',md.deltaH));
disp(sprintf('         DeltaH: %g ( maximum thickness difference between two time steps)',md.DeltaH));
disp(sprintf('         deltaT: %g ( minimum temperature difference between two time steps)',md.deltaT));
disp(sprintf('         DeltaT: %g ( maximum temperature difference between two time steps)',md.DeltaT));
disp(sprintf('         timeacc: %g ( multiplier to time step when time stepping increases time step)',md.timeacc));
disp(sprintf('         timedec: %g ( multiplier to time step when time stepping decresaes time step)',md.timedec));
disp(sprintf('      ''%s''','control'));

%control type
disp(sprintf('         control_type: %s (control type, ex: ''drag'', or ''B'')',md.control_type));
disp(sprintf('         fit: (%g)      ( 0 -> absolute, 1 -> relative, 2 -> logarithmic. default is absolute)',length(md.fit)));
disp(sprintf('         meanvel: %g      (velocity scaling factor when evaluating relative or logarithmic misfit)',md.meanvel));
disp(sprintf('         epsvel: %g      ( for relative fit, avoids misfit becoming infinity, for logarithmic fit, threshold for velocity)',md.epsvel));
disp(sprintf('         nsteps: %i      (number of optimization searches)',md.nsteps));
disp(sprintf('         optscal: (%i %i)      (scaling factor on gradient direction during optimization, for each optimization step)',size(md.optscal,1),size(md.optscal,2)));
disp(sprintf('         mincontrolconstraint: %f      (minimum contraint for the controlled parameters, NaN -> no constraint)',md.mincontrolconstraint));
disp(sprintf('         maxcontrolconstraint: %f      (maximum contraint for the controlled parameters, NaN -> no constraint)',md.maxcontrolconstraint));
disp(sprintf('         maxiter: (%i)      (maximum iterations during each optimization step)',length(md.maxiter)));
disp(sprintf('         tolx: %f      (minimum tolerance which will stop one optimization search)',md.tolx));
disp(sprintf('         plot: %i      (visualization of the results of each iteration yes -> 1 no -> 0. Default is 1)\n',md.plot));


%mesh
disp(sprintf('      ''%s''','mesh'));
disp(sprintf('         mesh_domainoutline: %s      (domain outlines)',md.mesh_domainoutline));
disp(sprintf('         mesh_riftoutline: %s      (rift outlines)',md.mesh_riftoutline));
disp(sprintf('         mesh_resolution: (%g)      (mesh resolutoin)\n',md.mesh_resolution));

%mesh2grid type
disp(sprintf('      ''%s''','mesh2grid'));
mesh2grid_string='';
for i=1:length(md.mesh2grid_parameters),
	parameter=md.mesh2grid_parameters{i};
	%check this parameter is a field from model! 
	if ~isfield(struct(md),parameter),
		error('displaysolutionparameters error message: one of the mesh2grid type parameters does not exist!');
	end
	mesh2grid_string=[mesh2grid_string parameter ' and '];
end
mesh2grid_string=mesh2grid_string(1:length(mesh2grid_string)-5);
disp(sprintf('         mesh2grid_parameters: %s %s',mesh2grid_string,'(list of parameters for which mesh 2 grid interpolation is carried out; ex: {''drag''}, or {''drag'',''B''})'));

%mesh2grid interpolation
mesh2grid_interpstring='';
for i=1:length(md.mesh2grid_interpolation),
	interpolation=md.mesh2grid_interpolation{i};
	mesh2grid_interpstring=[mesh2grid_interpstring interpolation ' and '];
end
mesh2grid_interpstring=mesh2grid_interpstring(1:length(mesh2grid_interpstring)-5);
disp(sprintf('         mesh2grid_interpolation: %s %s',mesh2grid_interpstring,'(list of interpolation (''node'' or ''element'') for each parameter ex: {''node''}, or {''node'',''element''})'));

%mesh2grid filter
mesh2grid_filterstring='';
for i=1:length(md.mesh2grid_filter),
	filter=md.mesh2grid_filter{i};
	mesh2grid_filterstring=[mesh2grid_filterstring filter ' and '];
end
mesh2grid_filterstring=mesh2grid_filterstring(1:length(mesh2grid_filterstring)-5);
disp(sprintf('         mesh2grid_filter: %s %s',mesh2grid_filterstring,'(list of filter (''average'' or ''nearest'') for each parameter ex: {''average''}, or {''average'',''nearest''})'));


disp(sprintf('         mesh2grid_cornereast: %g ( corner east of square grid)',md.mesh2grid_cornereast));
disp(sprintf('         mesh2grid_cornernorth: %g ( corner north of square grid)',md.mesh2grid_cornernorth));
disp(sprintf('         mesh2grid_xposting: %g (x  posting of grid (in m))',md.mesh2grid_xposting));
disp(sprintf('         mesh2grid_yposting: %g (y  posting of grid (in m))',md.mesh2grid_yposting));
disp(sprintf('         mesh2grid_nlines: %g ( number of grid lines)',md.mesh2grid_nlines));
disp(sprintf('         mesh2grid_ncolumns: %g ( number of grid columns)',md.mesh2grid_ncolumns));
disp(sprintf('         mesh2grid_windowsize: %g ( size of filter )\n',md.mesh2grid_windowsize));

%parallelisation
md.parallel

%parameteroutput type
parameteroutput_string='';
for i=1:length(md.parameteroutput),
	parameter=md.parameteroutput{i};
	%check this parameter is a field from model! 
	if ~isfield(struct(md),parameter),
		error('displaysolutionparameters error message: one of the parameteroutput type parameters does not exist!');
	end
	parameteroutput_string=[parameteroutput_string parameter ' and '];
end
parameteroutput_string=parameteroutput_string(1:length(parameteroutput_string)-5);

disp(sprintf('      ''%s''','output'));
disp(sprintf('         parameteroutput: %s %s',parameteroutput_string,...
                       '(list of output parameters recovered in the solution sequences: ex: {''viscousheating''}, or {''viscousheating'',''deviatoricstress''})'));

%qmu
disp(sprintf('\n'));
displayqmu(md);
