/*!\file:  dofsetgen.cpp
 * \brief  create list of dofs.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../Alloc/alloc.h"
#include "../../include/macros.h"
#include "stdio.h"

#undef __FUNCT__ 
#define __FUNCT__ "dofsetgen"

double* dofsetgen(int numdofs,int* doflist,int dofspernode,int totaldofs){

	int i,j;
	int count=0;

	/*output: */
	double* outdoflist=NULL;

	/*number of nodes :*/
	int numberofnodes;

	/*allocate: */
	numberofnodes=(int)totaldofs/dofspernode;
	outdoflist=(double*)xmalloc(numberofnodes*numdofs*sizeof(double));

	count=0;
	for(i=0;i<numberofnodes;i++){
		for(j=0;j<numdofs;j++){
			outdoflist[numdofs*i+j]=count+doflist[j] + 1 ;//-1 because dofs vector comes from Matlab, where indices start at 1.
		}
		count+=dofspernode;
	}

	/*Assign output pointers:*/
	return outdoflist;

}

