/*\file InputExtrude.c
 *\brief: extrude input vertically
 */

#include "./InputExtrude.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Loads      *loads      = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;
	int         NameEnum;
	bool        ifcollapsed=false;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	//CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputExtrudeUsage); Cant' use it here, as we have variable inputs.
	if((nlhs!=NLHS) || (nrhs!=7 && nrhs!=8)){
		InputExtrudeUsage();
		ISSMERROR(" usage. See above");
	}

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	FetchData(&NameEnum,NAME);
	if (nrhs==8){
		FetchData(&ifcollapsed,IFCOLLAPSED);
	}

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	if (nrhs==7)
	 InputExtrudex(elements,nodes,vertices,loads,materials,parameters,NameEnum);
	else
	 InputExtrudex(elements,nodes,vertices,loads,materials,parameters,NameEnum,ifcollapsed);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputExtrudeUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, name_enum);\n",__FUNCT__);
	_printf_("   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, name_enum,true);\n",__FUNCT__);
	_printf_("\n");
}
