/*!\file InputExtrudex
 * \brief: average field throfieldh thickness
 */

#include "./InputExtrudex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputExtrudex( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int enum_type,bool only_if_collapsed){

	int i;

	/*Then extrude vertically the new inputs*/
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		if (element->Enum()==PentaEnum){
			Penta* penta=(Penta*)element;
			penta->InputExtrude(enum_type,only_if_collapsed);
		}
	}

}
