/*!\file SurfaceAreax
 * \brief: compute Surface area
 */

#include "./SurfaceAreax.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SurfaceAreax( double* pS, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters){
	
	/*Intermediary*/
	Element* element=NULL;
	int i;

	/*output: */
	double S=0;
	double S_sum;
	
	/*Compute gradients: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		S+=element->SurfaceArea();
	}

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&S,&S_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&S_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	S=S_sum;

	/*Assign output pointers: */
	*pS=S;
}
