/*!\file Misfitx
 * \brief: compute misfit between observations and model
 */

#include "./Misfitx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void Misfitx( double* pJ, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters){
	
	/*Intermediary*/
	int fit;
	double S;
	int i;
	Element* element=NULL;

	/*output: */
	double J=0;
	double J_sum;
	
	/*Compute surface area: */
	SurfaceAreax(&S,elements,nodes,vertices, loads,materials,parameters);

	/*add surface area to elements :*/
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromVector(&S,SurfaceAreaEnum,ConstantEnum);
	}

	/*Compute Misfit: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		J+=element->Misfit();
	}

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&J,&J_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&J_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	J=J_sum;

	/*Assign output pointers: */
	*pJ=J;
}
