/*!\file InputControlConstrainx
 * \brief: Y=Y+aX operation on inputs.
 */

#include "./InputControlConstrainx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputControlConstrainx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,int control_type,double cm_min, double cm_max){

	/*intermediary:*/
	int      i;

    /*some early returns: */
	if(isnan(cm_min) & isnan(cm_max))return;

	/*Go through elemnets, and ask to carry out the ControlConstrain operation on inputs: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->InputControlConstrain(control_type,cm_min,cm_max);
	}
}
