/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"
#include "../modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void Gradjx( Vec* pgradient, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int control_type){

	int i;
	int dim;
	int numberofvertices;
	Vec gradient=NULL;
	
	/*retrieve some parameters: */
	parameters->FindParam(&dim,DimEnum);
	numberofvertices=vertices->NumberOfVertices();

	/*Allocate gradient: */
	gradient=NewVec(numberofvertices);

	/*Compute gradients: */
	for (i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->Gradj(gradient,control_type);
	}

	/*Assemble vector: */
	VecAssemblyBegin(gradient);
	VecAssemblyEnd(gradient);

	/*Extrude if needed: */
	if(dim==3) VecExtrudex(gradient, elements,nodes, vertices, loads, materials, parameters,0);

	/*Assign output pointers: */
	*pgradient=gradient;
}
