/*!\file ComputePressurex
 * \brief: compute pressure according to each element
 */

#include "./ComputePressurex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputePressurex( Vec* pp_g,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials,Parameters* parameters){

	/*intermediary*/
	int numberofnodes;
	int i;
	Element* element=NULL;

	/*output: */
	Vec p_g=NULL;

	/*Recover numberofnodes: */
	numberofnodes=nodes->NumberOfNodes();

	/*Allocate p_g on numberofnodes (only 1 dof): */
	p_g=NewVec(numberofnodes);

	/*Compute pressure for each element: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ComputePressure(p_g);
	}

	/*Assemble vector: */
	VecAssemblyBegin(p_g);
	VecAssemblyEnd(p_g);

	/*Assign output pointers: */
	*pp_g=p_g;
	
}
