function responses=SpawnCore(femmodel,variables,variabledescriptors,counter);
%SPAWNCORE - for Qmu analysis, using Dakota. Spawn the core solution.
%
%   Usage:
%      responses=SpawnCore(femmodel,variables,variabledescriptors)
%

%retrieve parameters
verbose=femmodel.parameters.Verbose;
responsedescriptors=femmodel.parameters.ResponseDescriptors; 
solution_type=femmodel.parameters.SolutionType;


displaystring(1,'%s%i',['   qmu iteration:'],counter);

%first update the inputs to the femmodel using the variables provided to us by dakota.
[femmodel.elements femmodel.loads femmodel.materials]=InputUpdateFromDakota(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,femmodel.part,variables,variabledescriptors);

%now run the core solution
[dummy,dummy,solutioncore]=SolutionConfiguration(solution_type);
eval(['femmodel=' solutioncore '(femmodel);']);

%now process the results to get response function values
responses=DakotaResponses(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,responsedescriptors);
