function femmodel=stokescontrolinit(femmodel),
%STOKESCONTROLINIT - initialize femmodel if control method on Stokes

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	isstokes=femmodel.parameters.IsStokes;
	stokesreconditioning=femmodel.parameters.StokesReconditioning;

	%if no Stokes analysis carried out, just return
	if (isstokes==0),
		return;
	end

	% For Stokes inverse control method, we are going to carry out the inversion only on the Stokes part. So we need to solve the Hutter or MacAyeal/Pattyn femmodel here, and constrain the Stokes femmodel using the Hutter or MacAyeal/Pattyn at the boundary. We don't want to have to do that at every inversion step, as it needs be done only once:

	%Compute slopes:
	femmodel=bedslope_core(femmodel);

	%Run a complete diagnostic to update the Stokes spcs:
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
	femmodel=solver_diagnostic_nonlinear([],[],[],femmodel,conserve_loads);

	%vertical velocity
	femmodel=solver_linear([],femmodel);

	%recondition pressure computed previously:
	femmodel.elements=InputDuplicate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureEnum,PressureStokesEnum);
	femmode.elements=InputScale(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,PressureStokesEnum,1.0/stokesreconditioning);

	displaystring(verbose,'\n%s',['      update boundary conditions for stokes using velocities previously computed...']);
	femmodel=ResetBoundaryConditions(femmodel,DiagnosticStokesAnalysisEnum);

	displaystring(verbose,'\n%s',['      computing stokes velocity and pressure...']);
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum);
	femmode=solver_diagnostic_nonlinear([],[],[],femmodel,conserve_loads);
