/*!\file: NodeSet.cpp
 * \brief routines for handling node sets (m,n,f and s sets)
 */ 

#include "../include/include.h"
#include "../shared/shared.h"
#include "./objects.h"

/*constructors and destructors*/
/*FUNCTION NodeSets::NodeSets{{{1*/
NodeSets::NodeSets( double* nodesets_pv_m,double* nodesets_pv_n,double* nodesets_pv_f,double* nodesets_pv_s,
		int nodesets_gsize,int nodesets_msize,int nodesets_nsize,int nodesets_fsize,int nodesets_ssize){

	gsize=nodesets_gsize;
	msize=nodesets_msize;
	nsize=nodesets_nsize;
	fsize=nodesets_fsize;
	ssize=nodesets_ssize;

	pv_m=nodesets_pv_m;
	pv_n=nodesets_pv_n;
	pv_f=nodesets_pv_f;
	pv_s=nodesets_pv_s;

}/*}}}*/
/*FUNCTION NodeSets::~NodeSets{{{1*/
NodeSets::~NodeSets(void){

	xfree((void**)&pv_m);
	xfree((void**)&pv_n);
	xfree((void**)&pv_f);
	xfree((void**)&pv_s);

}/*}}}*/

/*Object management*/
/*FUNCTION NodeSets::Echo{{{1*/
void NodeSets::Echo(void){
	
	int i;

	printf("\nNodeSets echo:\n");
	printf(" gsize: %i\n",gsize);
	printf(" msize: %i\n",msize);
	printf(" nsize: %i\n",nsize);
	printf(" fsize: %i\n",fsize);
	printf(" ssize: %i\n",ssize);

	if(pv_m){
		printf("m set:\n");
		for(i=0;i<msize;i++){
			printf("%g\n",pv_m[i]);
		}
	}
		
	if(pv_n){
		printf("n set:\n");
		for(i=0;i<nsize;i++){
			printf("%g\n",pv_n[i]);
		}
	}
	
	if(pv_f){
		printf("f set:\n");
		for(i=0;i<fsize;i++){
			printf("%g\n",pv_f[i]);
		}
	}
	
	if(pv_s){
		printf("s set:\n");
		for(i=0;i<ssize;i++){
			printf("%g\n",pv_s[i]);
		}
	}	
}/*}}}*/
/*FUNCTION NodeSets::GetGSize{{{1*/
int NodeSets::GetGSize(){
	return gsize;
}/*}}}*/
/*FUNCTION NodeSets::GetMSize{{{1*/
int NodeSets::GetMSize(){
	return msize;
}/*}}}*/
/*FUNCTION NodeSets::GetNSize{{{1*/
int NodeSets::GetNSize(){
	return nsize;
}/*}}}*/
/*FUNCTION NodeSets::GetFSize{{{1*/
int NodeSets::GetFSize(){
	return fsize;
}/*}}}*/
/*FUNCTION NodeSets::GetSSize{{{1*/
int NodeSets::GetSSize(){
	return ssize;
}/*}}}*/
/*FUNCTION NodeSets::GetPV_M{{{1*/
double* NodeSets::GetPV_M(){
	return pv_m;
}/*}}}*/
/*FUNCTION NodeSets::GetPV_N{{{1*/
double* NodeSets::GetPV_N(){
	return pv_n;
}/*}}}*/
/*FUNCTION NodeSets::GetPV_F{{{1*/
double* NodeSets::GetPV_F(){
	return pv_f;
}/*}}}*/
/*FUNCTION NodeSets::GetPV_S{{{1*/
double* NodeSets::GetPV_S(){
	return pv_s;
}/*}}}*/
