/*!\file Spc.c
 * \brief: implementation of the Spc object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../Container/Container.h"
#include "../objects.h"

/*Spc constructors and destructor*/
/*FUNCTION Spc::Spc(){{{1*/
Spc::Spc(){
	return;
}
/*}}}1*/
/*FUNCTION Spc::Spc(int spc_sid,int spc_nodeid,...){{{1*/
Spc::Spc(int spc_sid,int spc_nodeid, int spc_dof,double spc_value,int spc_analysis_type){

	sid=spc_sid;
	nodeid=spc_nodeid;
	dof=spc_dof;
	value=spc_value;
	analysis_type=spc_analysis_type;

	return;
}
/*}}}1*/
/*FUNCTION Spc::~Spc{{{1*/
Spc::~Spc(){
	return;
}
/*}}}1*/
		
/*Object virtual functions definitions:*/
/*FUNCTION Spc::Echo {{{1*/
void Spc::Echo(void){

	printf("Spc:\n");
	printf("   sid: %i\n",sid);
	printf("   nodeid: %i\n",nodeid);
	printf("   dof: %i\n",dof);
	printf("   value: %g\n",value);
	printf("   analysis_type: %s\n",EnumAsString(analysis_type));
	return;
}
/*}}}1*/
/*FUNCTION Spc::DeepEcho {{{1*/
void Spc::DeepEcho(void){

	printf("Spc:\n");
	printf("   sid: %i\n",sid);
	printf("   nodeid: %i\n",nodeid);
	printf("   dof: %i\n",dof);
	printf("   value: %g\n",value);
	printf("   analysis_type: %s\n",EnumAsString(analysis_type));
	return;
}		
/*}}}1*/
/*FUNCTION Spc::Id {{{1*/
int    Spc::Id(void){ return sid; }
/*}}}1*/
/*FUNCTION Spc::MyRank {{{1*/
int    Spc::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}1*/
/*FUNCTION Spc::Marshall {{{1*/
void  Spc::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Spc: */
	enum_type=SpcEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Spc data: */
	memcpy(marshalled_dataset,&sid,sizeof(sid));marshalled_dataset+=sizeof(sid);
	memcpy(marshalled_dataset,&nodeid,sizeof(nodeid));marshalled_dataset+=sizeof(nodeid);
	memcpy(marshalled_dataset,&dof,sizeof(dof));marshalled_dataset+=sizeof(dof);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&analysis_type,sizeof(analysis_type));marshalled_dataset+=sizeof(analysis_type);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}1*/
/*FUNCTION Spc::MarshallSize {{{1*/
int   Spc::MarshallSize(){

	return sizeof(sid)
		+sizeof(nodeid)
		+sizeof(dof)
		+sizeof(value)
		+sizeof(analysis_type)
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}1*/
/*FUNCTION Spc::Demarshall {{{1*/
void  Spc::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&sid,marshalled_dataset,sizeof(sid));marshalled_dataset+=sizeof(sid);
	memcpy(&nodeid,marshalled_dataset,sizeof(nodeid));marshalled_dataset+=sizeof(nodeid);
	memcpy(&dof,marshalled_dataset,sizeof(dof));marshalled_dataset+=sizeof(dof);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&analysis_type,marshalled_dataset,sizeof(analysis_type));marshalled_dataset+=sizeof(analysis_type);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}1*/
/*FUNCTION Spc::Enum {{{1*/
int Spc::Enum(void){

	return SpcEnum;

}
/*}}}1*/
/*FUNCTION Spc::copy {{{1*/
Object* Spc::copy() {
	return new Spc(*this); 
}
/*}}}1*/

/*Spc functions*/
/*FUNCTION Spc::GetDof {{{1*/
int Spc::GetDof(){
	return dof;
}
/*}}}1*/
/*FUNCTION Spc::GetNodeId {{{1*/
int   Spc::GetNodeId(){
	
	return nodeid;
}
/*}}}1*/
/*FUNCTION Spc::GetValue {{{1*/
double Spc::GetValue(){
	return value;
}
/*}}}1*/
/*FUNCTION Spc::InAnalysis{{{1*/
bool Spc::InAnalysis(int in_analysis_type){
	if (in_analysis_type==this->analysis_type) return true;
	else return false;
}
/*}}}*/
