/*!\file StringExternalResult.c
 * \brief: implementation of the StringExternalResult object
 */

/*header files: */
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*StringExternalResult constructors and destructor*/
/*FUNCTION StringExternalResult::StringExternalResult(){{{1*/
StringExternalResult::StringExternalResult(){
	return;
}
/*}}}*/
/*FUNCTION StringExternalResult::StringExternalResult(int enum_type,IssmString value){{{1*/
StringExternalResult::StringExternalResult(int in_id, int in_enum_type,char* in_value,int in_step, double in_time){

	id=in_id;
	enum_type=in_enum_type;
	value=(char*)xmalloc((strlen(in_value)+1)*sizeof(char));
	strcpy(value,in_value);
	step=in_step;
	time=in_time;
	
}
/*}}}*/
/*FUNCTION StringExternalResult::~StringExternalResult(){{{1*/
StringExternalResult::~StringExternalResult(){
	xfree((void**)&value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION StringExternalResult::Echo {{{1*/
void StringExternalResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringExternalResult::DeepEcho{{{1*/
void StringExternalResult::DeepEcho(void){

	printf("StringExternalResult:\n");
	printf("   id: %i\n",this->id);
	printf("   enum:  %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %s\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION StringExternalResult::Id{{{1*/
int    StringExternalResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringExternalResult::MyRank{{{1*/
int    StringExternalResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION StringExternalResult::Marshall{{{1*/
void  StringExternalResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;
	int   stringsize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of StringExternalResult: */
	enum_value=StringExternalResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);

	/*marshall data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	stringsize=strlen(this->value)+1;
	
	memcpy(marshalled_dataset,&stringsize,sizeof(stringsize));marshalled_dataset+=sizeof(stringsize);
	memcpy(marshalled_dataset,this->value,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION StringExternalResult::MarshallSize{{{1*/
int   StringExternalResult::MarshallSize(){

	int stringsize;
	stringsize=strlen(this->value)+1;
	
	return sizeof(int)+
		+stringsize*sizeof(char)
		+sizeof(id)
		+sizeof(enum_type)
		+sizeof(step)
		+sizeof(time)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION StringExternalResult::Demarshall{{{1*/
void  StringExternalResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;
	int   stringsize;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	memcpy(&stringsize,marshalled_dataset,sizeof(int));marshalled_dataset+=sizeof(int);
	
	this->value=(char*)xmalloc(stringsize*sizeof(char));
	memcpy(value,marshalled_dataset,stringsize*sizeof(char));marshalled_dataset+=stringsize*sizeof(char);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION StringExternalResult::Enum{{{1*/
int StringExternalResult::Enum(void){

	return StringExternalResultEnum;

}
/*}}}*/
/*FUNCTION StringExternalResult::copy{{{1*/
Object* StringExternalResult::copy() {
	
	return new StringExternalResult(this->id,this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*StringExternalResult management: */
/*FUNCTION StringExternalResult::WriteData{{{1*/
void   StringExternalResult::WriteData(FILE* fid){

	int     length;
	int     type;
	char   *name      = NULL;
	extern  int my_rank;

	/*return if now on cpu 0: */
	if(my_rank)return;

	/*First write enum: */
	name=EnumAsString(this->enum_type);
	length=(strlen(name)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(name,length,1,fid);

	/*Now write time and step: */
	fwrite(&time,sizeof(double),1,fid);
	fwrite(&step,sizeof(int),1,fid);

	/*writing a string, type is 2: */
	type=2;
	fwrite(&type,sizeof(int),1,fid);
	
	length=(strlen(this->value)+1)*sizeof(char);
	fwrite(&length,sizeof(int),1,fid);
	fwrite(this->value,length,1,fid);

}
/*}}}1*/
/*FUNCTION StringExternalResult::GetResultName{{{1*/
char* StringExternalResult::GetResultName(void){
	return  EnumAsString(this->enum_type);
}
/*}}}*/
/*FUNCTION StringExternalResult::SetMatlabField{{{1*/
#ifdef _SERIAL_
void  StringExternalResult::SetMatlabField(mxArray* dataref){
	
	char* name=NULL;

	name=this->GetResultName();

	mxSetField( dataref, this->step-1, name, mxCreateString(value));
	mxSetField( dataref, this->step-1, "time",mxCreateDoubleScalar((double)this->time)); 
	mxSetField( dataref, this->step-1, "step",mxCreateDoubleScalar((double)this->step)); 

}
#endif
/*}}}*/
/*FUNCTION StringExternalResult::GetStep{{{1*/
int StringExternalResult::GetStep(void){

	return this->step;
}
/*}}}*/
