/*!\file:  OptFunc.cpp
 * \brief: "C" code wrapper to matlab objectivefunctionC call
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"

#ifdef _SERIAL_
#include "mex.h"
double OptFunc(double scalar, OptArgs* optargs){
	
	/*output: */
	double J;

	mxArray*   inputs[3];
	mxArray*   psearch_scalar=NULL;
	mxArray*   mxJ=NULL;

	psearch_scalar=mxCreateDoubleScalar(scalar);
	inputs[0]=psearch_scalar;
	inputs[1]=optargs->femmodel;
	inputs[2]=optargs->n;

	mexCallMATLAB( 1, &mxJ, 3, (mxArray**)inputs, optargs->function_name);

	/*extract misfit from mxArray*/
	J=mxGetScalar(mxJ);

	return J;
}
#else
double OptFunc(double scalar, OptArgs* optargs){
	ISSMERROR(" not implemented yet");
}
#endif
