/*\file ControlOptimization.c
 *\brief: control optimization (replaces fmincon from matlab)
 */

#include "./ControlOptimization.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	char* function_name=NULL;
	double xmin,xmax;
	double tolerance;
	double* maxiter;
	OptArgs optargs;
	OptPars optpars;

	/*output: */
	double search_scalar;
	double J;

	/*arguments to objectivefunctionC: */
	int      n_value;
	double*  cm_jump=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlOptimizationUsage);

	/*Input datasets: */
	FetchData(&function_name,FUNCTIONNAME);
	FetchData(&xmin,XMIN);
	FetchData(&xmax,XMAX);
	FetchData(&tolerance,mxGetField(OPTIONS,0,"TolX"));
	FetchData(&maxiter,NULL,NULL,mxGetField(OPTIONS,0,"MaxIter"));

	/*Parameters: */
	FetchData(&cm_jump,NULL,NULL,mxGetField(PARAMETERS,0,"CmJump"));
	FetchData(&n_value,STEP);

	optargs.function_name=function_name;
	optargs.femmodel=FEMMODEL;
	optargs.n=STEP;

	optpars.xmin=xmin;
	optpars.xmax=xmax;
	optpars.tolerance=tolerance;
	optpars.maxiter=(int)maxiter[n_value-1];
	optpars.cm_jump=cm_jump[n_value-1];

	BrentSearch(&search_scalar,&J,&optpars,&OptFunc,&optargs);

	/*write output : */
	WriteData(SEARCHSCALAR,search_scalar);
	WriteData(MISFIT,J);

	/*Free ressources: */
	xfree((void**)&function_name);
	xfree((void**)&cm_jump);
	xfree((void**)&maxiter);

	/*end module: */
	MODULEEND();
}

void ControlOptimizationUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [search_scalar J] = %s(function_name,xmin,xmax,options,femmodel,step,parameters)\n",__FUNCT__);
	_printf_("\n");
}
