function convergence=controlconvergence(J,fit,eps_cm,n)
%CONTROLCONVERGENCE - determine the convergence of control_core solution
%
%   Usage:
%       converged=controlconvergence(J,fit,eps_cm,n);

	convergence=0;
	if ~isnan(eps_cm),
		i=n-2;
		%go through the previous misfits(starting from n-2)
		while (i>=1),
			if (fit(i)==fit(n)),
				%convergence test only if we have the same misfits
				if ((c(i).J-c(n).J)/c(n).J <= eps_cm),
					%convergence if convergence criteria fullfilled
					convergence=1;
					displaystring(verbose,'\n%s%g%s%g\n','      Convergence criterion: dJ/J = ',(c(i).J-c(n).J)/c(n).J,'<',eps_cm);
				else
					displaystring(verbose,'\n%s%g%s%g\n','      Convergence criterion: dJ/J = ',(c(i).J-c(n).J)/c(n).J,'>',eps_cm);
				end
				break;
			end
			i=i-1;                                                                                                                                         
		end
	end

end %end function
