/*\file InputAXPY.c
 *\brief: duplicate input
 */

#include "./InputAXPY.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements*   elements=NULL;
	Nodes*      nodes=NULL;
	Vertices*   vertices=NULL;
	Loads*      loads=NULL;
	Materials*  materials=NULL;
	Parameters* parameters=NULL;
	int         xenum,yenum; 
	double      scalar;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputAXPYUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	FetchData(&xenum,XENUM);
	FetchData(&scalar,SCALAR);
	FetchData(&yenum,YENUM);

	/*!Call core code: */
	InputAXPYx( elements, nodes, vertices, loads, materials,parameters,xenum,scalar,yenum);

	/*write output : */
	WriteData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputAXPYUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, xenum,scalar,yenum);\n",__FUNCT__);
	_printf_("\n");
}
