function femmodel=adjoint_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	isstokes=femmodel.parameters.IsStokes;
	dim=femmodel.parameters.Dim;
	solution_type=femmodel.parameters.SolutionType;
	conserve_loads=true;

	%set analysis type to compute velocity:
	if(isstokes),
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum);
	else 
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
	end

	displaystring('\n%s',['      recover solution for this stiffness and right hand side:']);
	[femmodel,ug,K_ff0,K_fs0]=solver_diagnostic_nonlinear(femmodel,conserve_loads);

	displaystring('\n%s',['      Build Du, difference between observed and modeled velocities:']);
	du_g=Du(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

	displaystring('\n%s',['      reduce adjoint load from g_set to f_set:']);
	du_f=Reduceloadfromgtof(du_g,femmodel.Gmn,K_fs0,femmodel.ys,femmodel.nodesets,true); %true means that ys0 flag is activated: all spcs show 0 displacement

	displaystring('\n%s',['      solve for adjoint vector:']);
	adjoint_f=Solver(K_ff0,du_f,[],femmodel.parameters);

	displaystring('\n%s',['      merge back to g set:']);
	adjoint_g=Mergesolutionfromftog(adjoint_f,femmodel.Gmn,femmodel.ys,femmodel.nodesets,true);%true means that ys0 flag is activated: all spc are 0

	%Update inputs using adjoint solution, and same type of setup as diagnostic solution:
	if(isstokes),
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticStokesAnalysisEnum,AdjointStokesAnalysisEnum);
	else
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	end

	femmodel.elements=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,adjoint_g);

	displaystring(verbose,'\n%s',['      saving results...']);
	if(solution_type==AdjointSolutionEnum)
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointyEnum);
		if(dim==3),
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointzEnum);
		end
	end

