/*!\file: stokescontrolinit.cpp
 * \brief: ...
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void stokescontrolinit(FemModel* femmodel){

	/*flags: */
	int    verbose = 0;
	bool   isstokes;
	double stokesreconditioning;
	bool   conserve_loads = true;
	
	/*first recover parameters common to all solutions:*/
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&isstokes,IsStokesEnum);
	femmodel->parameters->FindParam(&stokesreconditioning,StokesReconditioningEnum);

	/*if no Stokes analysis carried out, assign output and return*/
	if (!isstokes){
		femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);
		return;
	}

	/* For Stokes inverse control method, we are going to carry out the inversion only on the Stokes part. So we need 
	 * to solve the Hutter or MacAyeal/Pattyn femmodel here, and constrain the Stokes femmodel using the Hutter 
	 * or MacAyeal/Pattyn at the boundary. We don't want to have to do that at every inversion step, as 
	 * it needs be done only once: */

	/*Compute slopes: */
	bedslope_core(femmodel);
	
	/*Run a complete diagnostic to update the Stokes spcs: */
	femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);
	solver_diagnostic_nonlinear(NULL,NULL,NULL,femmodel,conserve_loads);

	//vertical velocity
	solver_linear(NULL,femmodel);

	if(verbose)_printf_("%s\n"," update boundary conditions for stokes using velocities previously computed...");
	ResetBoundaryConditions(femmodel,DiagnosticStokesAnalysisEnum);

	if(verbose)_printf_("%s\n"," computing stokes velocities and pressure ...");
	femmodel->SetCurrentConfiguration(DiagnosticStokesAnalysisEnum);
	solver_diagnostic_nonlinear(NULL,NULL,NULL,femmodel,conserve_loads);
}
