function femmodel=ResetBoundaryConditions(femmodel,analysis_type);
%RESETBOUNDARYCONDITIONS - change boundary conditions of a model
%
%   Change boundary condition of a model using a vector solution from another model
%
%   Usage:
%      femmodel=ResetBoundaryConditions(femmodel,analysis_type)


	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;

	displaystring(verbose,'\n%s',['updating boundary condition ...']);

	%set current analysis: 
	femmodel=SetCurrentConfiguration(femmodel,analysis_type);

	ug=GetSolutionFromInputs(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

	%For this analysis_type, free existing boundary condition vectors:
	analysis_counter=femmodel.parameters.AnalysisCounter+1; %matlab indexing on counter

	%global dof set
	femmodel.m_yg{analysis_counter}=[];
	%in the s-set
	femmodel.m_ys{analysis_counter}=[];

	%Now, duplicate ug (the solution vector) into the boundary conditions vector on the g-set
	femmodel.m_yg{analysis_counter}=ug;

	%Reduce from g to s set
	femmodel.m_ys{analysis_counter}=Reducevectorgtos(femmodel.m_yg{analysis_counter},femmodel.m_nodesets{analysis_counter});
