function converged=steadystateconvergence(femmodel),
%STEADYSTATECONVERGENCE - determine convergence of steady state solution
% 
%   Usage:
%      steadystateconvergence(femmodel)
	
	converged=0;
	velocity_convergence=0;
	temperature_convergence=0;

	%Retrieve parameters
	convergencecriterionvalue=femmodel.parameters.EpsRel;
	velocityenums=[VxEnum;VxOldEnum;VyEnum;VyOldEnum;VzEnum;VzOldEnum;PressureEnum;PressureOldEnum]; %pairs of enums (new and old) on which to carry out the converence tests
	temperatureenums=[TemperatureEnum;TemperatureOldEnum];
	convergencecriterion=[RelativeEnum]; %criterions for convergence, RelativeEnum or AbsoluteEnum 

	%Figure out convergence at the input level, because we don't have the solution vectors
	temperature_convergence=InputConvergence(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,temperatureenums,convergencecriterion,convergencecriterionvalue);
	velocity_convergence=InputConvergence(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,velocityenums,convergencecriterion,convergencecriterionvalue);

	if (velocity_convergence & temperature_convergence),
		converged=1;
	end
